/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.interactive.util;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public final class ResourceUtil {
    private ResourceUtil() {
    }

    public static void closeResource(Resource resource_p) {
        if (resource_p != null) {
            resource_p.unload();
            resource_p.getResourceSet().getResources().remove((Object)resource_p);
        }
    }

    public static void ensureLoaded(Resource resource_p) {
        if (!resource_p.isLoaded()) {
            try {
                resource_p.load(null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static Resource getCreateResourceForUri(URI uri_p, ResourceSet resourceSet_p) {
        Resource result = ResourceUtil.getResourceForUri(uri_p, resourceSet_p);
        if (result == null) {
            result = resourceSet_p.createResource(uri_p);
        }
        return result;
    }

    public static IFile getFileForPath(IPath path_p) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path_p);
    }

    public static IFile getFileForResource(Resource resource_p) {
        IFile result = null;
        URI uri = resource_p.getURI();
        if (uri != null) {
            result = ResourceUtil.getFileForUri(uri);
        }
        return result;
    }

    public static IFile getFileForUri(URI uri_p) {
        IFile result = null;
        if (uri_p.isPlatformResource()) {
            String platformString = uri_p.toPlatformString(true);
            result = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
        }
        return result;
    }

    public static Resource getResourceForUri(URI uri_p, ResourceSet resourceSet_p) {
        for (Resource resource : resourceSet_p.getResources()) {
            if (!uri_p.equals(resource.getURI())) continue;
            return resource;
        }
        return null;
    }

    public static URI getUriForFile(IFile file_p) {
        String stringPath = file_p.getFullPath().toString();
        URI result = URI.createPlatformResourceURI((String)stringPath, (boolean)true);
        return result;
    }

    public static boolean isPersistent(Resource resource_p) {
        boolean result = false;
        URI uri = resource_p.getURI();
        if (uri != null) {
            result = ResourceUtil.isPersistent(uri);
        }
        return result;
    }

    public static boolean isPersistent(URI uri_p) {
        boolean result = false;
        IResource eclipseResource = null;
        try {
            eclipseResource = ResourcesPlugin.getWorkspace().getRoot().findMember(uri_p.toPlatformString(true));
        }
        catch (Exception exception) {
            // empty catch block
        }
        result = eclipseResource instanceof IFile;
        return result;
    }

    public static boolean makePersistent(Resource resource_p) {
        boolean result = false;
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        try {
            resource_p.save(saveOptions);
            result = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}

