/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ui.properties.sections;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;
import org.polarsys.capella.core.ui.properties.controllers.IMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.ReferenceTableField;
import org.polarsys.capella.core.ui.properties.helpers.DialogHelper;
import org.polarsys.capella.core.ui.properties.sections.AbstractSection;
import org.polarsys.capella.core.ui.properties.viewers.AbstractPropertyValueCellEditorProvider;
import org.polarsys.capella.core.ui.properties.viewers.ICellEditorProvider;
import org.polarsys.capella.core.ui.properties.viewers.IDelegatedViewer;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaIncomingRelation;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaOutgoingRelation;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaRelation;
import org.polarsys.capella.vp.requirements.model.helpers.ViewpointHelper;
import org.polarsys.capella.vp.requirements.ui.properties.controllers.RequirementIncomingLinkController;
import org.polarsys.capella.vp.requirements.ui.properties.controllers.RequirementOutgoingLinkController;
import org.polarsys.capella.vp.requirements.ui.properties.labelproviders.CapellaElementColumnLabelProvider;
import org.polarsys.capella.vp.requirements.ui.properties.labelproviders.RelationTypeColumnLabelProvider;
import org.polarsys.capella.vp.requirements.ui.properties.widgets.RelationTypeTableDelegatedViewer;
import org.polarsys.kitalpha.vp.requirements.Requirements.Requirement;
import org.polarsys.kitalpha.vp.requirements.Requirements.RequirementsPackage;

public class RequirementSection
extends AbstractSection {
    protected EObject requirement;
    private ReferenceTableField incomingTableField;
    protected final String[] _columnProperties = new String[]{"Source element", "Relation type"};
    private ReferenceTableField outgoingTableField;
    protected final String[] outgoingColumnProperties = new String[]{"Target element", "Relation type"};

    public boolean select(Object eObject) {
        EObject eObjectToTest = super.selection(eObject);
        return ViewpointHelper.isViewpointActive((EObject)eObjectToTest) && eObjectToTest instanceof Requirement;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EObject newEObject = super.setInputSelection(part, selection);
        if (newEObject instanceof Requirement) {
            this.loadData(newEObject);
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.rootParentComposite.setLayout((Layout)new GridLayout());
        this.rootParentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Group grp = this.getWidgetFactory().createGroup(this.rootParentComposite, "");
        grp.setLayout((Layout)new GridLayout(2, false));
        grp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setUpFields(grp);
    }

    public void loadData(EObject requirement) {
        super.loadData(requirement);
        this.requirement = requirement;
        this.incomingTableField.loadData(requirement, (EStructuralFeature)RequirementsPackage.eINSTANCE.getRequirement_OwnedRelations());
        this.outgoingTableField.loadData(requirement, (EStructuralFeature)RequirementsPackage.eINSTANCE.getRequirement_OwnedRelations());
    }

    public List<AbstractSemanticField> getSemanticFields() {
        return Collections.emptyList();
    }

    protected void setUpFields(Group grp) {
        this.incomingTableField = new ReferenceTableField((Composite)grp, this.getWidgetFactory(), null, "Incoming links", (IMultipleSemanticFieldController)new RequirementIncomingLinkController(), (IDelegatedViewer)new RelationTypeTableDelegatedViewer(this.getWidgetFactory(), (ICellEditorProvider)new AbstractPropertyValueCellEditorProvider()){

            protected String[] getColumnProperties() {
                return RequirementSection.this._columnProperties;
            }

            protected boolean createViewerColumns() {
                this.createTableViewerColumn(0, new CapellaElementColumnLabelProvider());
                this.createTableViewerColumn(1, new RelationTypeColumnLabelProvider());
                return true;
            }

            @Override
            public StructuredSelection getSelectedObjectFromSelection(TableItem[] inSelection) {
                if (inSelection != null && inSelection.length > 0) {
                    CapellaRelation relation = (CapellaRelation)inSelection[0].getData();
                    CapellaElement elementToDisplay_p = null;
                    elementToDisplay_p = relation instanceof CapellaOutgoingRelation ? ((CapellaOutgoingRelation)relation).getSource() : ((CapellaIncomingRelation)relation).getTarget();
                    return new StructuredSelection((Object)elementToDisplay_p);
                }
                return null;
            }
        }){

            protected List<EObject> getReferencedElementsByContainedOnes() {
                return this._controller.loadValues(this.semanticElement, this.semanticFeature);
            }

            protected void handleBrowse() {
                AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                    public void run() {
                        List availableElements = _controller.readOpenValues(semanticElement, semanticFeature, true);
                        List allResults = (List)DialogHelper.openMultiSelectionDialog((Control)_browseBtn, (Collection)availableElements);
                        if (allResults != null) {
                            _controller.writeOpenValues(semanticElement, semanticFeature, allResults);
                        }
                    }
                };
                TransactionHelper.getExecutionManager((EObject)this.semanticElement).execute((ICommand)command);
                this.refreshViewer();
            }

            protected void handleDelete() {
                List selectedReferencedElements;
                ColumnViewer columnViewer;
                if (this._delegatedViewer != null && (columnViewer = this._delegatedViewer.getColumnViewer()) != null && !(selectedReferencedElements = ((IStructuredSelection)columnViewer.getSelection()).toList()).isEmpty()) {
                    AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                        public void run() {
                            for (EObject eObj : selectedReferencedElements) {
                                if (!(eObj instanceof CapellaOutgoingRelation)) continue;
                                CapellaElement srcElement = ((CapellaOutgoingRelation)eObj).getSource();
                                srcElement.getOwnedExtensions().remove((Object)((CapellaOutgoingRelation)eObj));
                            }
                        }
                    };
                    TransactionHelper.getExecutionManager((EObject)this.semanticElement).execute((ICommand)command);
                    this.refreshViewer();
                }
            }

            protected void createCustomActions(Composite parent) {
                this._browseBtn = this.createTableButton(parent, CapellaUIPropertiesPlugin.getDefault().getImage("Add_16x16.gif"), new Runnable(){

                    @Override
                    public void run() {
                        this.handleBrowse();
                    }
                });
            }
        };
        this.outgoingTableField = new ReferenceTableField((Composite)grp, this.getWidgetFactory(), null, "Outgoing links", (IMultipleSemanticFieldController)new RequirementOutgoingLinkController(), (IDelegatedViewer)new RelationTypeTableDelegatedViewer(this.getWidgetFactory(), (ICellEditorProvider)new AbstractPropertyValueCellEditorProvider()){

            protected String[] getColumnProperties() {
                return RequirementSection.this.outgoingColumnProperties;
            }

            protected boolean createViewerColumns() {
                this.createTableViewerColumn(0, new CapellaElementColumnLabelProvider());
                this.createTableViewerColumn(1, new RelationTypeColumnLabelProvider());
                return true;
            }

            @Override
            public StructuredSelection getSelectedObjectFromSelection(TableItem[] inSelection) {
                if (inSelection != null && inSelection.length > 0) {
                    CapellaRelation relation = (CapellaRelation)inSelection[0].getData();
                    CapellaElement elementToDisplay_p = null;
                    elementToDisplay_p = relation instanceof CapellaOutgoingRelation ? ((CapellaOutgoingRelation)relation).getSource() : ((CapellaIncomingRelation)relation).getTarget();
                    return new StructuredSelection((Object)elementToDisplay_p);
                }
                return null;
            }
        }){

            protected List<EObject> getReferencedElementsByContainedOnes() {
                return this._controller.loadValues(this.semanticElement, this.semanticFeature);
            }

            protected void handleBrowse() {
                AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                    public void run() {
                        List availableElements = _controller.readOpenValues(semanticElement, semanticFeature, true);
                        List allResults = (List)DialogHelper.openMultiSelectionDialog((Control)_browseBtn, (Collection)availableElements);
                        if (allResults != null) {
                            _controller.writeOpenValues(semanticElement, semanticFeature, allResults);
                        }
                    }
                };
                TransactionHelper.getExecutionManager((EObject)this.semanticElement).execute((ICommand)command);
                this.refreshViewer();
            }

            protected void handleDelete() {
                List selectedReferencedElements;
                ColumnViewer columnViewer;
                if (this._delegatedViewer != null && (columnViewer = this._delegatedViewer.getColumnViewer()) != null && !(selectedReferencedElements = ((IStructuredSelection)columnViewer.getSelection()).toList()).isEmpty()) {
                    AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                        public void run() {
                            if (semanticElement instanceof Requirement) {
                                Requirement requirement = (Requirement)semanticElement;
                                for (EObject eObj : selectedReferencedElements) {
                                    if (!(eObj instanceof CapellaIncomingRelation)) continue;
                                    requirement.getOwnedRelations().remove((Object)((CapellaIncomingRelation)eObj));
                                }
                            }
                        }
                    };
                    TransactionHelper.getExecutionManager((EObject)this.semanticElement).execute((ICommand)command);
                    this.refreshViewer();
                }
            }

            protected void createCustomActions(Composite parent) {
                this._browseBtn = this.createTableButton(parent, CapellaUIPropertiesPlugin.getDefault().getImage("Add_16x16.gif"), new Runnable(){

                    @Override
                    public void run() {
                        this.handleBrowse();
                    }
                });
            }
        };
    }
}

